/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.selectiveAttention.ui;

import hsr.pma.app.joystick.ButtonListener;
import hsr.pma.app.view.components.AButton;
import hsr.pma.app.view.components.ALabel;
import hsr.pma.app.view.components.NextButton;
import hsr.pma.app.view.graphics.ApplicationLayouter;
import hsr.pma.testapp.selectiveAttention.app.MemoVolume;
import hsr.pma.testapp.selectiveAttention.app.StepHandler;
import hsr.pma.testapp.selectiveAttention.sound.IVoice;
import hsr.pma.testapp.selectiveAttention.ui.SelectiveAttentionLayouter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class VolumePanel
extends JPanel
implements Observer,
ButtonListener {
    private static final long serialVersionUID = 1L;
    private static final String BUTTON_INC_TEXT = "+";
    private static final String BUTTON_DEC_TEXT = "-";
    private static final float VOLUME_SCALE_FACTOR = 100.0f;
    protected static final int MAX_VOLUME = 100;
    protected static final int MIN_VOLUME = 50;
    private static final int ACT_VOLUME = 75;
    private static final int VOLUME_OFFSET = 5;
    private int actualVolume = 75;
    private String volumeCombination = "";
    private IVoice voiceThread;
    private StepHandler stepHandler;
    private JLabel labelTitle = new ALabel();
    private JButton incVolume = new AButton("+");
    private JButton decVolume = new AButton("-");
    private JButton next = new NextButton();
    private JLabel labelDec = new ALabel("F5");
    private JLabel labelInc = new ALabel("F8");
    private SelectiveAttentionLayouter layouter;

    public VolumePanel(StepHandler stepHandler, String title, String volumeCombination) {
        this.setLayout(null);
        this.setOpaque(true);
        this.setBackground(ApplicationLayouter.COLOR_BACKGROUND);
        this.volumeCombination = volumeCombination;
        this.stepHandler = stepHandler;
        this.layouter = new SelectiveAttentionLayouter(this);
        this.labelTitle.setText(title);
        this.add(this.labelTitle);
        this.add(this.labelInc);
        this.add(this.labelDec);
        this.voiceThread = stepHandler.getVoice();
        this.initializeButtons();
        this.voiceThread.addObserver(this);
        stepHandler.setButtonListener(this);
    }

    private void initializeButtons() {
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (VolumePanel.this.next.isEnabled()) {
                    VolumePanel.this.handleNextPressed();
                }
            }
        };
        this.next.addActionListener(al);
        this.add(this.next);
        this.decVolume.setMargin(new Insets(0, 0, 0, 0));
        this.decVolume.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VolumePanel.this.handleVolumeDown();
            }
        });
        this.add(this.decVolume);
        this.incVolume.setMargin(new Insets(0, 0, 0, 0));
        this.incVolume.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VolumePanel.this.handleVolumeUp();
            }
        });
        this.add(this.incVolume);
        this.incVolume.getInputMap(2).put(KeyStroke.getKeyStroke(119, 0), "F8_PRESSED");
        this.incVolume.getActionMap().put("F8_PRESSED", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                VolumePanel.this.handleVolumeUp();
            }
        });
        this.decVolume.getInputMap(2).put(KeyStroke.getKeyStroke(116, 0), "F5_PRESSED");
        this.decVolume.getActionMap().put("F5_PRESSED", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                VolumePanel.this.handleVolumeDown();
            }
        });
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width < 10) {
            return;
        }
        if (height < 10) {
            return;
        }
        this.myLayout();
    }

    private void myLayout() {
        this.layouter.layoutTitle(this.labelTitle, 105);
        this.layouter.layoutVolumeButtonLabels(this.decVolume, this.incVolume, this.labelDec, this.labelInc);
        this.layouter.layoutNextButton(this.next);
    }

    private void handleVolumeDown() {
        this.actualVolume -= 5;
        this.actualVolume = this.actualVolume < 50 ? 50 : this.actualVolume;
        this.stepHandler.setVolume((float)this.actualVolume / 100.0f);
        this.next.setEnabled(false);
        this.incVolume.setEnabled(false);
        this.decVolume.setEnabled(false);
        this.repaint();
        this.voiceThread.play(this.volumeCombination);
    }

    private void handleVolumeUp() {
        this.actualVolume += 5;
        this.actualVolume = this.actualVolume > 100 ? 100 : this.actualVolume;
        this.stepHandler.setVolume((float)this.actualVolume / 100.0f);
        this.next.setEnabled(false);
        this.incVolume.setEnabled(false);
        this.decVolume.setEnabled(false);
        this.repaint();
        this.voiceThread.play(this.volumeCombination);
    }

    private void handleNextPressed() {
        this.stepHandler.setVolume((float)this.actualVolume / 100.0f);
        MemoVolume memo = new MemoVolume();
        memo.setVolume((float)this.actualVolume / 100.0f);
        this.stepHandler.getApp().fireMemo(memo);
        this.stepHandler.nextStep();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.layouter.layoutVolumeSlider(this.actualVolume, g);
        this.requestFocusInWindow();
    }

    public void update(Observable o, Object arg) {
        this.next.setEnabled(true);
        this.incVolume.setEnabled(true);
        this.decVolume.setEnabled(true);
    }

    public void handleButtonPressed(int arg0) {
        switch (arg0) {
            case 0: {
                if (!this.decVolume.isEnabled()) break;
                this.dispatchActionEventPaint(this.decVolume);
                break;
            }
            case 3: {
                if (!this.incVolume.isEnabled()) break;
                this.dispatchActionEventPaint(this.incVolume);
                break;
            }
            case 4: {
                if (!this.next.isEnabled()) break;
                this.dispatchActionEventPaint(this.next);
            }
        }
    }

    private void dispatchActionEventPaint(JButton but) {
        but.getModel().setArmed(true);
        but.getModel().setPressed(true);
        Dimension d = but.getSize();
        but.paintImmediately(0, 0, d.width, d.height);
        ActionEvent evt = new ActionEvent(but, 1001, but.getActionCommand());
        ActionListener[] actionListenerArray = but.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener listener = actionListenerArray[n2];
            listener.actionPerformed(evt);
            ++n2;
        }
        but.getModel().setArmed(false);
        but.getModel().setPressed(false);
    }
}

