/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.selectiveAttention.ui;

import hsr.pma.app.joystick.ButtonListener;
import hsr.pma.app.view.components.AButton;
import hsr.pma.app.view.graphics.ApplicationLayouter;
import hsr.pma.testapp.selectiveAttention.app.StepHandler;
import hsr.pma.testapp.selectiveAttention.ui.SelectiveAttentionLayouter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class TestPanel
extends JPanel
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private static final String BUTTON_TEXT = "F8";
    private static final String ACTION_KEY = "F8_PRESSED";
    private SelectiveAttentionLayouter layouter;
    private JButton f8 = new AButton("F8");
    private StepHandler stepHandler;
    private boolean correct;
    private boolean isFeedback;

    public TestPanel(StepHandler sh) {
        this.setLayout(null);
        this.setOpaque(true);
        this.setBackground(ApplicationLayouter.COLOR_BACKGROUND);
        this.stepHandler = sh;
        this.layouter = new SelectiveAttentionLayouter(this);
        this.initializeButton();
        this.stepHandler.setButtonListener(this);
        this.setFocusable(true);
    }

    public TestPanel(StepHandler sh, boolean correct, boolean wasClicked) {
        this.setLayout(null);
        this.setOpaque(true);
        this.setBackground(ApplicationLayouter.COLOR_BACKGROUND);
        this.correct = correct;
        this.isFeedback = true;
        this.layouter = new SelectiveAttentionLayouter(this);
        this.initializeButton(wasClicked);
    }

    private void initializeButton() {
        this.f8.setMargin(new Insets(0, 0, 0, 0));
        this.f8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestPanel.this.stepHandler.click();
                TestPanel.this.f8.removeActionListener(this);
                TestPanel.this.f8.setEnabled(false);
            }
        });
        this.f8.getInputMap(2).put(KeyStroke.getKeyStroke(119, 0), ACTION_KEY);
        this.f8.getActionMap().put(ACTION_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                TestPanel.this.stepHandler.click();
                TestPanel.this.f8.getActionMap().remove(TestPanel.ACTION_KEY);
                TestPanel.this.f8.setEnabled(false);
            }
        });
        this.add(this.f8);
    }

    private void initializeButton(boolean wasClicked) {
        this.f8.setMargin(new Insets(0, 0, 0, 0));
        this.f8.setEnabled(false);
        this.add(this.f8);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width < 10) {
            return;
        }
        if (height < 10) {
            return;
        }
        this.myLayout();
    }

    private void myLayout() {
        this.layouter.layoutAnswerButton(this.f8);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.layouter.layoutSpeaker(g2);
        if (this.isFeedback) {
            this.layouter.layoutFeedback(this.correct, g2);
        }
    }

    public void handleButtonPressed(int arg0) {
        if (arg0 == 3 && this.f8.isEnabled()) {
            this.dispatchActionEventPaint(this.f8);
        }
    }

    private void dispatchActionEventPaint(JButton but) {
        but.getModel().setArmed(true);
        but.getModel().setPressed(true);
        Dimension d = but.getSize();
        but.paintImmediately(0, 0, d.width, d.height);
        ActionEvent evt = new ActionEvent(but, 1001, but.getActionCommand());
        ActionListener[] actionListenerArray = but.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener listener = actionListenerArray[n2];
            listener.actionPerformed(evt);
            ++n2;
        }
        but.getModel().setArmed(false);
        but.getModel().setPressed(false);
    }
}

