/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.selectiveAttention.sound;

import hsr.pma.testapp.selectiveAttention.sound.IVoice;
import hsr.pma.testapp.selectiveAttention.sound.Synthesizer;
import java.util.Observable;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class VoicePlayer
extends Observable
implements IVoice {
    public static boolean DEBUG = true;
    private static final float MIN_VOLUME = -40.0f;
    private static final float MAX_VOLUME = 3.0f;
    private Synthesizer synthesizer;
    private Worker worker;
    private static final String DISPOSE = "**DISPOSE**";
    private final Object lock = new Object();
    private Vector<String> fifo = new Vector();

    public VoicePlayer() {
        this.synthesizer = new Synthesizer();
    }

    public void prepare() {
        this.synthesizer.prepare();
        this.worker = new Worker();
        this.worker.start();
    }

    public void setVolume(float volume) {
        float db = -40.0f * (1.0f - volume) + 3.0f * volume;
        if (DEBUG) {
            System.out.println("[VoicePlayer] setVolume (db): " + db);
        }
        this.synthesizer.setVolume(db);
    }

    public float getVolume() {
        float volume = (-40.0f - this.synthesizer.getVolume()) / -43.0f;
        if (DEBUG) {
            System.out.println("[VoicePlayer] getVolume (rel): " + volume);
        }
        return this.synthesizer.getVolume() / 60.0f + 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(String sequence) {
        if (DEBUG) {
            System.out.println("[VoicePlayer] putSound: " + sequence);
        }
        this.push(sequence);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public void putSound(String sequence) {
        this.play(sequence);
    }

    private synchronized void push(String s) {
        this.fifo.add(s);
    }

    private synchronized String pop() {
        if (this.fifo.size() == 0) {
            return null;
        }
        String result = this.fifo.get(0);
        int i = 1;
        while (i < this.fifo.size()) {
            this.fifo.set(i - 1, this.fifo.get(i));
            ++i;
        }
        this.fifo.remove(this.fifo.size() - 1);
        return result;
    }

    private synchronized void handleDispose() {
        this.fifo.clear();
        this.fifo.add(DISPOSE);
    }

    public void stop() {
        this.synthesizer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.synthesizer.stop();
        this.handleDispose();
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    private void fireObserver() {
        if (DEBUG) {
            System.out.println("[VoicePlayer] fire update");
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VoicePlayer.this.setChanged();
                VoicePlayer.this.notifyObservers();
            }
        });
    }

    class Worker
    extends Thread {
        public Worker() {
            this.setName("VoicePlayer-Worker");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (DEBUG) {
                System.out.println("[VoicePlayer:Worker] started");
            }
            while (true) {
                boolean die = false;
                String x = VoicePlayer.this.pop();
                while (x != null) {
                    if (x.equals(VoicePlayer.DISPOSE)) {
                        if (DEBUG) {
                            System.out.println("[VoicePlayer:Worker] received dispose");
                        }
                        die = true;
                        break;
                    }
                    if (DEBUG) {
                        System.out.println("[VoicePlayer:Worker] play " + x);
                    }
                    VoicePlayer.this.synthesizer.play(x);
                    VoicePlayer.this.fireObserver();
                    x = VoicePlayer.this.pop();
                }
                if (die) break;
                Object object = VoicePlayer.this.lock;
                synchronized (object) {
                    try {
                        if (DEBUG) {
                            System.out.println("[VoicePlayer:Worker] entering wait");
                        }
                        VoicePlayer.this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (DEBUG) {
                        System.out.println("[VoicePlayer:Worker] leaving wait");
                    }
                }
            }
            if (DEBUG) {
                System.out.println("[VoicePlayer:Worker] terminated");
            }
        }
    }
}

