/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.selectiveAttention.pd;

import hsr.pma.util.Time;
import java.io.Serializable;

public class TestStepResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int FACTOR_MILLION = 1000000;
    private String combination;
    private Resulttype type;
    private long reactionTime;
    private Time started;

    public TestStepResult(String combination, boolean isCritial, long reactionTime, Time started) {
        this.type = isCritial ? (reactionTime >= 0L ? Resulttype.Hit : Resulttype.Miss) : (reactionTime >= 0L ? Resulttype.FalseAlarm : Resulttype.CorrectRejection);
        this.combination = combination;
        this.reactionTime = reactionTime;
        this.started = started;
    }

    public TestStepResult(String combination, Resulttype type, long reactiontime, Time started) {
        this.combination = combination;
        this.type = type;
        this.reactionTime = reactiontime;
        this.started = started;
    }

    public String getCombination() {
        return this.combination;
    }

    public Resulttype getType() {
        return this.type;
    }

    public long getReactiontimeInNanos() {
        return this.reactionTime;
    }

    public long getReactionTime() {
        return this.reactionTime / 1000000L;
    }

    public String toString() {
        return String.valueOf(this.combination) + " " + this.type.name() + " " + (this.reactionTime == -1L ? "" : Long.valueOf(this.reactionTime / 1000000L));
    }

    public boolean isCorrect() {
        return this.type == Resulttype.Hit || this.type == Resulttype.CorrectRejection;
    }

    public Time getStarted() {
        return this.started;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Resulttype {
        Hit,
        Miss,
        FalseAlarm,
        CorrectRejection;

    }
}

