/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.selectiveAttention.app;

import hsr.pma.Language;
import hsr.pma.app.ITestApplication;
import hsr.pma.app.joystick.ButtonListener;
import hsr.pma.testapp.selectiveAttention.app.Application;
import hsr.pma.testapp.selectiveAttention.app.StepFactory;
import hsr.pma.testapp.selectiveAttention.pd.ResultStep;
import hsr.pma.testapp.selectiveAttention.pd.RuleStep;
import hsr.pma.testapp.selectiveAttention.pd.Step;
import hsr.pma.testapp.selectiveAttention.pd.TestStep;
import hsr.pma.testapp.selectiveAttention.pd.TestsequenceStep;
import hsr.pma.testapp.selectiveAttention.sound.IVoice;
import hsr.pma.testapp.selectiveAttention.sound.VoicePlayer;
import hsr.pma.util.Clock;
import hsr.pma.util.Time;
import java.awt.BorderLayout;
import java.io.Serializable;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepHandler
implements Observer,
Serializable {
    private static final long serialVersionUID = 1L;
    private int index;
    private long stopwatch;
    private JPanel mainPanel;
    private JPanel currentPanel;
    private List<Step> steps;
    protected IVoice voiceThread;
    private Timer timer;
    private StepFactory factory;
    private ButtonListener joystickButtonListener;
    private Application app;
    Time ruleStarted = new Time();

    public StepHandler(Application app) {
        this.app = app;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public StepFactory getFactory() {
        return this.factory;
    }

    public Application getApp() {
        return this.app;
    }

    public void initialize() {
        if (this.voiceThread == null) {
            this.voiceThread = this.createVoice();
            this.voiceThread.prepare();
            this.voiceThread.setVolume(0.75f);
            this.voiceThread.addObserver(this);
        }
        if (this.timer == null) {
            this.timer = new Timer();
        }
    }

    private IVoice createVoice() {
        return new VoicePlayer();
    }

    private TimerTask getTask() {
        return new TimerTask(){

            public void run() {
                StepHandler.this.nextStep();
            }
        };
    }

    public void setFactory(StepFactory factory) {
        this.factory = factory;
    }

    public void setLanguage(Language lang) {
        this.factory.setLanguage(lang);
    }

    public void setPanel(JPanel panel) {
        this.mainPanel = panel;
        this.mainPanel.setLayout(new BorderLayout());
    }

    public void startInstruction() {
        this.initialize();
        this.index = -1;
        this.steps = this.factory.getInstructionSteps();
        this.nextStep();
    }

    public void startTest() {
        this.initialize();
        this.index = -1;
        this.steps = this.factory.getTestSteps();
        this.nextStep();
    }

    public int getTestCount() {
        return this.factory.getTestCount();
    }

    public void startTest(int index) {
        this.factory.setTest(index);
        this.startTest();
    }

    public void startFailover(int number) {
        this.initialize();
        this.steps = this.factory.getTestSteps();
        this.index = -1;
        while (number > 0) {
            if (this.steps.get((this.index + 1) % this.steps.size()) instanceof TestsequenceStep) {
                --number;
            }
            ++this.index;
            this.index %= this.steps.size();
        }
        this.nextStep();
    }

    public void nextStep() {
        Step ns;
        if (this.index >= 0) {
            this.steps.get(this.index).finished();
        }
        if (this.app.getState() == ITestApplication.State.PAUSE) {
            return;
        }
        if (this.app.getState() == ITestApplication.State.INSTRUCTING) {
            if (this.index == this.steps.size() - 1) {
                this.app.setState(ITestApplication.State.PAUSE);
                return;
            }
            ++this.index;
        } else if (this.app.getState() == ITestApplication.State.TESTING) {
            if (this.index == this.steps.size() - 1) {
                this.app.setState(ITestApplication.State.ENDED);
                return;
            }
            ++this.index;
        }
        if (this.currentPanel != null) {
            this.mainPanel.remove(this.currentPanel);
        }
        if ((ns = this.steps.get(this.index)) instanceof ResultStep) {
            ((ResultStep)ns).setStepHandler(this);
        }
        ns.setReactionTime(-1L);
        if (ns instanceof RuleStep) {
            this.ruleStarted = Clock.getInstance().getTime();
        } else if (ns instanceof TestStep) {
            TestStep ts = (TestStep)ns;
            ts.setStarted(Clock.getInstance().getTime());
        } else if (ns instanceof TestsequenceStep) {
            TestsequenceStep tss = (TestsequenceStep)ns;
            tss.setStarted(this.ruleStarted);
        }
        this.currentPanel = ns.createPanel(this);
        if (this.currentPanel != null) {
            this.mainPanel.add(this.currentPanel);
        }
        System.out.println("step shown: " + ns);
        this.mainPanel.validate();
        String sound = this.steps.get(this.index).getCombination();
        if (sound != null) {
            this.voiceThread.play(sound);
        } else {
            this.update(null, null);
        }
        this.stopwatch = System.nanoTime();
    }

    public void click() {
        this.steps.get(this.index).setReactionTime(System.nanoTime() - this.stopwatch);
    }

    public void stop() {
        this.timer.cancel();
        this.timer = null;
        if (this.currentPanel != null) {
            this.mainPanel.remove(this.currentPanel);
        }
        this.mainPanel.validate();
        this.voiceThread.stop();
        this.voiceThread = null;
    }

    @Override
    public void update(Observable observable, Object obj) {
        int duration = this.steps.get(this.index).getDuration();
        if (duration > 0 && this.timer != null) {
            this.timer.schedule(this.getTask(), duration);
        } else if (duration == 0) {
            this.nextStep();
        }
    }

    public IVoice getVoice() {
        return this.voiceThread;
    }

    public void setButtonListener(ButtonListener bl) {
        this.joystickButtonListener = bl;
    }

    public void handleButtonPressed(int joystickButton) {
        this.joystickButtonListener.handleButtonPressed(joystickButton);
    }

    public void setVolume(float volume) {
        if (this.voiceThread != null) {
            this.voiceThread.setVolume(volume);
        } else {
            System.err.println("[StepHandler:setVolume()] voiceThread is null");
        }
    }

    public float getVolume() {
        if (this.voiceThread != null) {
            return this.voiceThread.getVolume();
        }
        System.err.println("[StepHandler:getVolume()] voiceThread is null, returning default");
        return 0.75f;
    }

    public void saveFracturedTestSequence() {
        if (this.index == -1) {
            return;
        }
        Step activeStep = this.steps.get(this.index);
        if (!(activeStep instanceof TestStep)) {
            return;
        }
        TestsequenceStep testsequenceStep = null;
        int indexSearch = this.index;
        while (indexSearch < this.steps.size()) {
            Step step = this.steps.get(indexSearch);
            if (step instanceof TestsequenceStep) {
                testsequenceStep = (TestsequenceStep)step;
                break;
            }
            ++indexSearch;
        }
        if (testsequenceStep == null) {
            return;
        }
        testsequenceStep.saveFractionalResult(this.ruleStarted);
    }
}

