/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.selectiveAttention.app;

import hsr.pma.Language;
import hsr.pma.app.DefaultTestApplication;
import hsr.pma.app.IResultStep;
import hsr.pma.app.ITestApplication;
import hsr.pma.app.Memo;
import hsr.pma.app.ResultStep;
import hsr.pma.app.view.ObserverArg;
import hsr.pma.testapp.selectiveAttention.app.MemoVolume;
import hsr.pma.testapp.selectiveAttention.app.StepFactory;
import hsr.pma.testapp.selectiveAttention.app.StepHandler;
import hsr.pma.testapp.selectiveAttention.pd.Result;
import hsr.pma.testapp.selectiveAttention.sound.SoundLoader;
import hsr.pma.testapp.selectiveAttention.sound.Synthesizer;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
extends DefaultTestApplication {
    private static final long serialVersionUID = 1L;
    public static boolean DEBUG = DEBUG = false;
    public static final String APPLICATION_NAME = "Selective-Attention";
    public static final String CLASS_NAME = "hsr.pma.testapp.selectiveAttention.app.Application";
    public static final String CLASS_NAME_RESULTSTEP = "hsr.pma.testapp.selectiveAttention.pd.Result";
    private StepHandler stepHandler;
    protected String name = "";
    protected String abbrevation = "";
    protected String description = "";
    private Element config;
    private int resultStepCount = 0;

    static {
        Synthesizer.DEBUG = DEBUG;
        SoundLoader.DEBUG = DEBUG;
        Result.DEBUG = DEBUG;
    }

    public Application() {
        this.setState(ITestApplication.State.READY);
        this.stepHandler = new StepHandler(this);
    }

    public Application(Element element) {
        this();
        this.config = (Element)element.getChild("Configuration").clone();
        this.config.detach();
        try {
            this.stepHandler.setFactory(new StepFactory(this, this.config));
            this.setAttributesFromXML(element);
        }
        catch (Exception e) {
            this.fireException(e);
        }
    }

    @Override
    public String getApplicationName() {
        return APPLICATION_NAME;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassNameResultStep() {
        return CLASS_NAME_RESULTSTEP;
    }

    @Override
    public void setResultSteps(ArrayList<IResultStep> arg0) {
        this.resultStepCount = arg0.size();
    }

    @Override
    public void startFailover() {
        if (DEBUG) {
            System.out.println("SelAtt App: startTest(int)");
        }
        this.setState(ITestApplication.State.TESTING);
        this.stepHandler.startFailover(this.resultStepCount);
    }

    @Override
    public void setConfiguration(Element element) {
        if (DEBUG) {
            System.out.println("SelAtt App: setConfiguration(Element) called");
        }
        this.config = element;
        try {
            this.stepHandler.setFactory(new StepFactory(this, this.config));
        }
        catch (Exception e) {
            this.fireException(e);
        }
    }

    @Override
    public void setPanel(JPanel panel) {
        if (DEBUG) {
            System.out.println("SelAtt App: setPanel(JPanel) called");
        }
        this.stepHandler.setPanel(panel);
    }

    @Override
    public void startInstruction() {
        if (DEBUG) {
            System.out.println("SelAtt App: startInstruction() called");
        }
        this.setState(ITestApplication.State.INSTRUCTING);
        try {
            this.stepHandler.startInstruction();
        }
        catch (Exception e) {
            this.fireException(e);
        }
    }

    @Override
    public void startTest() {
        if (DEBUG) {
            System.out.println("SelAtt App: startTest() called");
        }
        this.setState(ITestApplication.State.TESTING);
        try {
            this.stepHandler.startTest();
        }
        catch (Exception e) {
            this.fireException(e);
        }
    }

    @Override
    public int getTestCount() {
        return this.stepHandler.getTestCount();
    }

    @Override
    public void startTest(int index) {
        this.setState(ITestApplication.State.TESTING);
        try {
            this.stepHandler.startTest(index);
        }
        catch (Exception e) {
            this.fireException(e);
        }
    }

    @Override
    public void stopInstruction() {
        if (DEBUG) {
            System.out.println("SelAtt App: stopInstruction() called");
        }
        this.setState(ITestApplication.State.PAUSE);
        try {
            this.stepHandler.stop();
        }
        catch (Exception e) {
            this.fireException(e);
        }
    }

    @Override
    public void stopTest() {
        if (DEBUG) {
            System.out.println("SelAtt App: stopTest() called");
        }
        this.stepHandler.saveFracturedTestSequence();
        this.setState(ITestApplication.State.ENDED);
        try {
            this.stepHandler.stop();
        }
        catch (Exception e) {
            this.fireException(e);
        }
    }

    @Override
    public Element toXML() {
        Element element = new Element("TestApplication");
        this.writeAttributesToXML(element);
        element.addContent(this.getConfiguration());
        return element;
    }

    public static Application fromXML(Element element) {
        if (DEBUG) {
            System.out.println("SelAtt App: fromXML() called");
        }
        return new Application(element);
    }

    @Override
    public Element getConfiguration() {
        Element clone = (Element)this.config.clone();
        return clone;
    }

    public void fireResult(ResultStep resultsequence) {
        if (DEBUG) {
            System.out.println("SelAtt App: fireResult() called");
        }
        ObserverArg arg = new ObserverArg(2, resultsequence);
        this.setChanged();
        this.notifyObservers(arg);
    }

    @Override
    public void setLanguage(Language language) {
        if (DEBUG) {
            System.out.println("SelAtt App: setLanguage() called");
        }
        this.language = language;
        this.stepHandler.setLanguage(language);
    }

    @Override
    public Language getLanguage() {
        if (DEBUG) {
            System.out.println("SelAtt App: getLanguage() called");
        }
        return this.language;
    }

    @Override
    public void handleButtonPressed(int joystickButton) {
        if (DEBUG) {
            System.out.println("SelAtt App: handleButtonPressed() called");
        }
        this.stepHandler.handleButtonPressed(joystickButton);
    }

    @Override
    public void abort() {
        if (this.stepHandler.getVoice() != null) {
            this.stepHandler.getVoice().stop();
        }
    }

    @Override
    public void init() {
        this.stepHandler.initialize();
    }

    @Override
    public void dispose() {
        if (this.stepHandler.getVoice() != null) {
            this.stepHandler.getVoice().dispose();
        }
    }

    @Override
    public void setMemos(ArrayList<Memo> memos) {
        if (memos.size() == 0) {
            return;
        }
        Memo x = memos.get(memos.size() - 1);
        if (x instanceof MemoVolume) {
            MemoVolume vmemo = (MemoVolume)x;
            this.stepHandler.setVolume(vmemo.getVolume());
        }
    }

    @Override
    public void fireException(Exception e) {
        e.printStackTrace();
        super.fireException(e);
    }
}

