/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.standalone.view;

import hsr.pma.app.view.components.ALabel;
import hsr.pma.standalone.Locator;
import hsr.pma.standalone.model.EndScreen;
import hsr.pma.standalone.view.GraphicsContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EndPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final EndScreen screen;
    private JLabel text;

    public EndPanel(EndScreen screen) {
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.screen = screen;
        this.setLayout(null);
        this.text = new ALabel(screen.getText().getText());
        this.add(this.text);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width > 100) {
            this.mylayout();
        }
    }

    public void mylayout() {
        GraphicsContext gc = Locator.getGraphicsContext();
        this.text.setFont(gc.getFont(this.screen.getText().getFontSize()));
        Dimension d = this.getSize();
        Insets p = this.screen.getPadding().getInsets();
        int width = d.width - p.left - p.right;
        int height = d.height - p.top - p.bottom;
        int twidth = this.text.getPreferredSize().width;
        int theight = this.text.getPreferredSize().height;
        int xOffset = p.left + (width - twidth) / 2;
        int yOffset = p.top + (height - theight) / 2;
        this.text.setBounds(xOffset, yOffset, twidth, theight);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        String himgname = this.screen.getHeader().getImage();
        Image himage = Locator.getImageProvider().getScaledImage(himgname);
        g.drawImage(himage, 0, 0, himage.getWidth(null), himage.getHeight(null), null);
        String fimgname = this.screen.getFooter().getImage();
        Image fimage = Locator.getImageProvider().getScaledImage(fimgname);
        int yoffset = this.getSize().height - fimage.getHeight(null);
        g.drawImage(fimage, 0, yoffset, fimage.getWidth(null), fimage.getHeight(null), null);
    }
}

