/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.standalone.view;

import hsr.pma.app.view.components.AButton;
import hsr.pma.app.view.components.ALabel;
import hsr.pma.standalone.Locator;
import hsr.pma.standalone.model.ControlScreen;
import hsr.pma.standalone.view.GraphicsContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ControlPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static boolean DEBUG = false;
    private final ControlScreen screen;
    private JLabel title;
    private JButton buttonInstruction;
    private JButton buttonEnd;
    private List<JButton> testButtons = new ArrayList<JButton>();

    public ControlPanel(ControlScreen screen) {
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.screen = screen;
        this.setLayout(null);
        this.title = new ALabel(screen.getTitle().getText());
        this.add(this.title);
        this.buttonInstruction = new AButton(screen.getInstructionButton().getText());
        this.buttonInstruction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Locator.getController().startInstruction();
            }
        });
        this.add(this.buttonInstruction);
        int i = 0;
        while (i < screen.getTestButton().getCount()) {
            final AButton but = new AButton(screen.getTestButton().getText());
            but.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.handleStartTestButtonPresed(but);
                }
            });
            this.testButtons.add(but);
            this.add(but);
            ++i;
        }
        if (this.testButtons.size() == 1) {
            String x = this.testButtons.get(0).getText();
            this.testButtons.get(0).setText(x.replace("{0} ", ""));
        } else {
            i = 0;
            while (i < this.testButtons.size()) {
                String x = this.testButtons.get(i).getText();
                this.testButtons.get(i).setText(x.replace("{0}", "" + (i + 1)));
                ++i;
            }
        }
        this.buttonEnd = new AButton(screen.getEndButton().getText());
        this.buttonEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Locator.getController().showEnd();
            }
        });
        this.add(this.buttonEnd);
    }

    private void handleStartTestButtonPresed(JButton but) {
        Locator.getController().startTest(this.testButtons.indexOf(but));
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width > 100) {
            this.mylayout();
        }
    }

    private void mylayout() {
        GraphicsContext gc = Locator.getGraphicsContext();
        this.title.setFont(gc.getFontBold(this.screen.getTitle().getFontSize()));
        this.buttonInstruction.setFont(gc.getFontBold(this.screen.getInstructionButton().getFontSize()));
        for (JButton but : this.testButtons) {
            but.setFont(gc.getFontBold(this.screen.getTestButton().getFontSize()));
        }
        this.buttonEnd.setFont(gc.getFontBold(this.screen.getEndButton().getFontSize()));
        Dimension d = this.getSize();
        Insets p = this.screen.getPadding().getInsets();
        int width = d.width - p.left - p.right;
        int height = d.height - p.top - p.bottom;
        int unit = gc.getUnit();
        int bHeight = gc.getButtonHeight();
        int twidth = this.title.getPreferredSize().width;
        int theight = this.title.getPreferredSize().height;
        int xOffset = p.left + (width - twidth) / 2;
        this.title.setBounds(xOffset, p.top, twidth, theight);
        int bw1 = (int)((double)this.buttonInstruction.getPreferredSize().width * 1.2);
        int bw2 = (int)((double)this.testButtons.get((int)0).getPreferredSize().width * 1.2);
        if (bw2 > bw1) {
            bw1 = bw2;
        }
        xOffset = p.left + (width - bw1) / 2;
        int yOffset = p.top + height / 2 - bHeight - unit / 2;
        this.buttonInstruction.setBounds(xOffset, yOffset, bw1, bHeight);
        yOffset += bHeight + gc.getUnit();
        for (JButton but : this.testButtons) {
            but.setBounds(xOffset, yOffset, bw1, bHeight);
            yOffset += bHeight + gc.getUnit() / 2;
        }
        int bWidth = (int)((double)this.buttonEnd.getPreferredSize().width * 1.2);
        xOffset = d.width - bWidth - p.right;
        yOffset = d.height - bHeight - p.bottom;
        this.buttonEnd.setBounds(xOffset, yOffset, bWidth, bHeight);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintDebugBorder(g);
        String himgname = this.screen.getHeader().getImage();
        Image himage = Locator.getImageProvider().getScaledImage(himgname);
        g.drawImage(himage, 0, 0, himage.getWidth(null), himage.getHeight(null), null);
        String fimgname = this.screen.getFooter().getImage();
        Image fimage = Locator.getImageProvider().getScaledImage(fimgname);
        int yoffset = this.getSize().height - fimage.getHeight(null);
        g.drawImage(fimage, 0, yoffset, fimage.getWidth(null), fimage.getHeight(null), null);
    }

    private void paintDebugBorder(Graphics g) {
        if (!DEBUG) {
            return;
        }
        Dimension d = this.getSize();
        Insets p = this.screen.getPadding().getInsets();
        int width = d.width - p.left - p.right;
        int height = d.height - p.top - p.bottom;
        g.setColor(Color.RED);
        g.drawRect(p.left, p.top, width, height);
    }
}

