/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.standalone.model;

import hsr.pma.Language;
import java.util.Hashtable;
import org.jdom.Element;

public class Text {
    private static final int DEFAULT_FONT_SIZE_TITLE = 130;
    private static final int DEFAULT_FONT_SIZE_TEXT = 100;
    protected Hashtable<Language, String> texts = new Hashtable();
    protected int fontSize = 100;
    protected Language lang = Language.GERMAN;

    public Text() {
    }

    public Text(Element el) {
        this();
        String x = el.getAttributeValue("fontSize");
        this.fontSize = x != null ? Integer.parseInt(x) : (el.getName().equals("Title") ? 130 : 100);
        Language[] languageArray = Language.values();
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language lang = languageArray[n2];
            x = el.getChildText(lang.abbreviation);
            if (x != null) {
                this.texts.put(lang, x);
            }
            ++n2;
        }
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setLanguage(Language lang) {
        this.lang = lang;
    }

    public String getText() {
        String x = this.texts.get((Object)this.lang);
        if (x == null) {
            x = "";
        }
        return x;
    }

    public void setText(String text, Language lang) {
        if (text == null) {
            return;
        }
        this.texts.put(lang, text);
    }

    public Element toXml(String elementName) {
        Element el = new Element(elementName);
        int defaultFontSize = 100;
        if (elementName.equals("Title")) {
            defaultFontSize = 130;
        }
        if (this.fontSize != defaultFontSize) {
            el.setAttribute("fontSize", "" + this.fontSize);
        }
        Element ex = new Element(this.lang.abbreviation);
        ex.setText(this.getText());
        el.addContent(ex);
        return el;
    }
}

