/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.standalone.io;

import hsr.pma.app.DefaultTestApplication;
import hsr.pma.app.ITestApplication;
import hsr.pma.standalone.io.CryptInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class ApplicationIO {
    public static final String FILENAME = "config.xml";
    public static final String POSTFIX_CRYPTED = ".cry";
    public static String BASE_DIR = "";

    public ITestApplication readFromFile(String filename) throws Exception {
        String filePath = String.valueOf(BASE_DIR) + filename;
        File file = new File(filePath);
        if (file.exists()) {
            return this.read(file);
        }
        String cfilePath = filePath.replace(".xml", POSTFIX_CRYPTED);
        file = new File(cfilePath);
        if (file.exists()) {
            return this.read(file);
        }
        throw new RuntimeException("file not found: " + filePath);
    }

    public ITestApplication read(File file) throws Exception {
        ITestApplication iTestApplication;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            if (!file.getName().endsWith(POSTFIX_CRYPTED)) {
                ITestApplication iTestApplication2 = this.read(in);
                return iTestApplication2;
            }
            CryptInputStream cin = new CryptInputStream(in);
            iTestApplication = this.read(cin);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return iTestApplication;
    }

    public ITestApplication readFromJar() {
        block17: {
            ITestApplication iTestApplication;
            InputStream in = null;
            try {
                in = ClassLoader.getSystemClassLoader().getResourceAsStream(FILENAME.replace(".xml", POSTFIX_CRYPTED));
                if (in != null) {
                    CryptInputStream cin = new CryptInputStream(in);
                    ITestApplication iTestApplication2 = this.read(cin);
                    return iTestApplication2;
                }
                in = ClassLoader.getSystemClassLoader().getResourceAsStream(FILENAME);
                if (in == null) break block17;
                iTestApplication = this.read(in);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            return iTestApplication;
        }
        return null;
    }

    private ITestApplication read(InputStream istream) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(istream);
        Element root = doc.getRootElement();
        ITestApplication app = DefaultTestApplication.fromXMLs(root);
        return app;
    }
}

