/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.app.view;

import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;

public class ImageFactory {
    private static final String IMAGEDIR = "images/";
    private Hashtable<String, ImageIcon> images = new Hashtable();
    private static final ImageFactory instance = new ImageFactory();
    public static final String LOGO = "pma-logo.gif";
    public static final String NOIMAGE = "noimage.gif";

    private ImageFactory() {
        this.getImage(LOGO);
        this.getImage(NOIMAGE);
    }

    public static ImageFactory getInstance() {
        return instance;
    }

    public ImageIcon getImage(String name) {
        ImageIcon icon = this.images.get(name);
        if (icon == null && (icon = new ImageIcon(IMAGEDIR + name)).getIconWidth() == -1) {
            icon = null;
            try {
                URL url = this.getClass().getClassLoader().getResource(IMAGEDIR + name);
                if (url != null && (icon = new ImageIcon(url)).getIconWidth() == -1) {
                    icon = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (icon != null) {
            this.images.put(name, icon);
        }
        if (icon == null) {
            System.err.println("[ImageFactory] Bild nicht gefunden: " + name);
            icon = this.images.get(NOIMAGE);
            if (icon == null) {
                return new ImageIcon();
            }
        }
        return icon;
    }
}

