/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.app.joystick;

import de.hardcode.jxinput.Button;
import hsr.pma.app.joystick.ButtonListener;
import hsr.pma.app.joystick.FrameListener;
import hsr.pma.app.joystick.Joystick;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;

class JoystickButton
implements FrameListener {
    private final Button button;
    private final int number;
    AtomicBoolean pressed = new AtomicBoolean();
    Vector<ButtonListener> listeners = new Vector();

    public JoystickButton(Button button, int number, Joystick joystick) {
        this.button = button;
        this.number = number;
        this.addButtonListener(joystick);
    }

    @Override
    public void handleFrame() {
        boolean mystate;
        boolean state = this.button.getState();
        if (state == (mystate = this.pressed.get())) {
            return;
        }
        if (!mystate && state) {
            this.pressed.set(true);
            this.fireButtonPressed();
            return;
        }
        if (mystate && !state) {
            this.pressed.set(false);
        }
    }

    protected void addButtonListener(ButtonListener listener) {
        this.listeners.add(listener);
    }

    protected void removeButtonListener(ButtonListener listener) {
        this.listeners.remove(listener);
    }

    private void fireButtonPressed() {
        for (ButtonListener listener : this.listeners) {
            listener.handleButtonPressed(this.number);
        }
    }
}

