/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.standalone.view;

import hsr.pma.app.view.components.AButton;
import hsr.pma.app.view.components.ATextArea;
import hsr.pma.standalone.Locator;
import hsr.pma.standalone.model.LicenseScreen;
import hsr.pma.standalone.view.GraphicsContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class LicensePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static boolean DEBUG = false;
    private final LicenseScreen screen;
    private JTextArea title;
    private JTextArea text;
    private JButton button;

    public LicensePanel(LicenseScreen screen) {
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.screen = screen;
        this.setLayout(null);
        this.title = new ATextArea(screen.getTitle().getText());
        this.title.setEditable(false);
        this.add(this.title);
        this.text = new ATextArea(screen.getText().getText());
        this.text.setEditable(false);
        this.add(this.text);
        this.button = new AButton(screen.getButton().getText());
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Locator.getController().showControl();
            }
        });
        this.add(this.button);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width > 100) {
            this.mylayout();
        }
    }

    public void mylayout() {
        GraphicsContext gc = Locator.getGraphicsContext();
        this.title.setFont(gc.getFontBold(this.screen.getTitle().getFontSize()));
        this.text.setFont(gc.getFont(this.screen.getText().getFontSize()));
        this.button.setFont(gc.getFontBold(this.screen.getButton().getFontSize()));
        Dimension d = this.getSize();
        Insets p = this.screen.getPadding().getInsets();
        int width = d.width - p.left - p.right;
        int unit = gc.getTitleTextYGap();
        int bHeight = gc.getButtonHeight();
        int theight = this.title.getPreferredSize().height;
        this.title.setBounds(p.left, p.top, width, theight);
        int yOffset = p.top + theight + unit;
        theight = this.text.getPreferredSize().height;
        this.text.setBounds(p.left, yOffset, width, theight);
        int bwidth = (int)((double)this.button.getPreferredSize().width * 1.2);
        int xOffset = p.left + (width - bwidth) / 2;
        yOffset = d.height - p.bottom - bHeight;
        this.button.setBounds(xOffset, yOffset, bwidth, bHeight);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintDebugBorder(g);
        String himgname = this.screen.getHeader().getImage();
        Image himage = Locator.getImageProvider().getScaledImage(himgname);
        g.drawImage(himage, 0, 0, himage.getWidth(null), himage.getHeight(null), null);
        String fimgname = this.screen.getFooter().getImage();
        Image fimage = Locator.getImageProvider().getScaledImage(fimgname);
        int yoffset = this.getSize().height - fimage.getHeight(null);
        g.drawImage(fimage, 0, yoffset, fimage.getWidth(null), fimage.getHeight(null), null);
    }

    private void paintDebugBorder(Graphics g) {
        if (!DEBUG) {
            return;
        }
        Dimension d = this.getSize();
        Insets p = this.screen.getPadding().getInsets();
        int width = d.width - p.left - p.right;
        int height = d.height - p.top - p.bottom;
        g.setColor(Color.RED);
        g.drawRect(p.left, p.top, width, height);
    }
}

