/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.memorization.controller;

import hsr.pma.Language;
import hsr.pma.app.IResultStep;
import hsr.pma.app.ITestApplication;
import hsr.pma.memorization.controller.ControllerListener;
import hsr.pma.memorization.controller.JoystickListener;
import hsr.pma.memorization.controller.MemorizationApplication;
import hsr.pma.memorization.data.ResultStepHandler;
import hsr.pma.memorization.model.EmptySlide;
import hsr.pma.memorization.model.SequenceSlide;
import hsr.pma.memorization.model.Slide;
import hsr.pma.memorization.model.SlideFactory;
import hsr.pma.memorization.model.xml.Configuration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Controller
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<ControllerListener> listeners = new ArrayList<ControllerListener>();
    private JoystickListener joystickListener;
    private MemorizationApplication application;
    private Configuration configuration;
    private transient List<Slide> instructionSlides;
    private transient List<Slide> testSlides;
    private transient Slide activeSlide;
    private transient ResultStepHandler resultStepHandler;
    private List<IResultStep> failoverSteps = new ArrayList<IResultStep>();

    public Controller(MemorizationApplication application) {
        this.application = application;
    }

    public ITestApplication.State getState() {
        return this.application.getState();
    }

    public void saveResultStep(IResultStep resultStep) {
        this.application.saveResultStep(resultStep);
    }

    public Language getLanguage() {
        return this.application.getLanguage();
    }

    public ResultStepHandler getResultStepHandler() {
        return this.resultStepHandler;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void startInstruction() {
        SlideFactory factory = new SlideFactory(this);
        this.instructionSlides = factory.createInstructionSlides(this.configuration.getInstruction().getSteps());
        this.application.setState(ITestApplication.State.INSTRUCTING);
        if (this.instructionSlides.size() == 0) {
            System.err.println("Warning: no instruction slides");
            this.application.setState(ITestApplication.State.PAUSE);
            return;
        }
        this.activeSlide = this.instructionSlides.get(0);
        this.activeSlide.start();
        this.fireShowSlide(this.activeSlide);
    }

    public void stopInstruction() {
        if (this.activeSlide != null) {
            this.activeSlide.stop();
        }
        this.application.setState(ITestApplication.State.PAUSE);
        this.fireShowSlide(new EmptySlide());
    }

    public void startTest(int index) {
        this.configuration.setTestIndex(index);
        this.startTest();
    }

    public int getTestCount() {
        return this.configuration.getTestCount();
    }

    public void startTest() {
        SlideFactory factory = new SlideFactory(this);
        this.testSlides = factory.createTestSlides(this.configuration.getTest().getSteps());
        if (this.testSlides.size() == 0) {
            System.err.println("Warning: no test slides");
            this.application.setState(ITestApplication.State.ENDED);
            return;
        }
        this.resultStepHandler = new ResultStepHandler(this);
        this.application.setState(ITestApplication.State.TESTING);
        this.activeSlide = this.testSlides.get(0);
        this.activeSlide.start();
        this.fireShowSlide(this.activeSlide);
    }

    public void stopTest() {
        if (this.activeSlide != null) {
            this.activeSlide.stop();
        }
        this.application.setState(ITestApplication.State.ENDED);
        this.fireShowSlide(new EmptySlide());
    }

    public void setResultSteps(ArrayList<IResultStep> resultSteps) {
        if (resultSteps == null) {
            return;
        }
        this.failoverSteps = resultSteps;
    }

    public void startFailover() {
        if (this.failoverSteps.size() == 0) {
            this.startTest();
            return;
        }
        int searchIndex = this.failoverSteps.size();
        SequenceSlide target = null;
        int found = 0;
        for (Slide slide : this.testSlides) {
            if (!(slide instanceof SequenceSlide)) continue;
            if (found == searchIndex) {
                target = (SequenceSlide)slide;
                break;
            }
            ++found;
        }
        if (target == null) {
            System.err.println("Failover: not enough sequence slides");
            this.application.setState(ITestApplication.State.ENDED);
            return;
        }
        this.application.setState(ITestApplication.State.TESTING);
        this.activeSlide = target;
        this.activeSlide.start();
        this.fireShowSlide(this.activeSlide);
    }

    public void nextSlide() {
        Slide nextSlide = null;
        switch (this.application.getState()) {
            case INSTRUCTING: {
                int index = this.instructionSlides.indexOf(this.activeSlide);
                if (index == this.instructionSlides.size() - 1) {
                    this.application.setState(ITestApplication.State.PAUSE);
                    this.fireShowSlide(new EmptySlide());
                    return;
                }
                nextSlide = this.instructionSlides.get(++index);
                break;
            }
            case TESTING: {
                int index = this.testSlides.indexOf(this.activeSlide);
                if (index == this.testSlides.size() - 1) {
                    this.application.setState(ITestApplication.State.ENDED);
                    this.fireShowSlide(new EmptySlide());
                    return;
                }
                nextSlide = this.testSlides.get(++index);
                break;
            }
            default: {
                System.err.println("[Memorization:nextSlide()] illegal state " + (Object)((Object)this.application.getState()));
                return;
            }
        }
        this.activeSlide = nextSlide;
        this.activeSlide.start();
        this.fireShowSlide(this.activeSlide);
    }

    public void addControllerListener(ControllerListener listener) {
        this.listeners.add(listener);
    }

    private void fireShowSlide(Slide slide) {
        for (ControllerListener listener : this.listeners) {
            listener.showSlide(slide);
        }
    }

    public void setJoystickListener(JoystickListener joystickListener) {
        this.joystickListener = joystickListener;
    }

    protected void fireJoystickButtonPressed(int button) {
        this.joystickListener.joystickButtonPressed(button);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

