/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.app.joystick;

import de.hardcode.jxinput.Axis;
import hsr.pma.app.joystick.ButtonFirer;
import hsr.pma.app.joystick.ButtonListener;
import hsr.pma.app.joystick.FrameListener;
import hsr.pma.app.joystick.FrameThread;
import hsr.pma.app.joystick.HatSwitchFirer;
import hsr.pma.app.joystick.HatSwitchListener;
import hsr.pma.app.joystick.JoystickButton;
import hsr.pma.app.joystick.JoystickConfiguration;
import hsr.pma.app.joystick.JoystickHatSwitch;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;

public class Joystick
implements ButtonListener,
FrameListener,
HatSwitchListener {
    public static final int BUTTON1 = 0;
    public static final int BUTTON2 = 1;
    public static final int BUTTON3 = 2;
    public static final int BUTTON4 = 3;
    public static final int BUTTON_NEXT = 4;
    public static final int BUTTON_F2 = 5;
    public static final int BUTTON_F3 = 6;
    public static final int BUTTON_F4 = 7;
    public static final int FRAMERATE = 100;
    private static Joystick instance;
    protected FrameThread thread;
    private JoystickButton button1;
    private JoystickButton button2;
    private JoystickButton button3;
    private JoystickButton button4;
    private JoystickButton button5;
    private JoystickButton button_f2;
    private JoystickButton button_f3;
    private JoystickButton button_f4;
    private CopyOnWriteArrayList<FrameListener> frameListeners = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<ButtonListener> buttonListeners = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<HatSwitchListener> headSwitchListeners = new CopyOnWriteArrayList();
    private JoystickHatSwitch hatSwitch;
    private Axis xAxis;
    private Axis yAxis;
    private Axis sliderAxis;
    private Axis rotationAxis;
    private AtomicBoolean available = new AtomicBoolean();
    private AtomicBoolean enabled = new AtomicBoolean();
    private final JoystickConfiguration config = new JoystickConfiguration();

    protected Joystick() {
        if (!this.config.isJoystickAvailable()) {
            this.available.set(false);
        } else {
            this.available.set(true);
        }
        this.thread = new FrameThread();
        if (this.available.get()) {
            if (this.config.getButton1() != null) {
                this.button1 = new JoystickButton(this.config.getButton1(), 0, this);
                this.thread.addFrameListener(this.button1);
            }
            if (this.config.getButton2() != null) {
                this.button2 = new JoystickButton(this.config.getButton2(), 1, this);
                this.thread.addFrameListener(this.button2);
            }
            if (this.config.getButton3() != null) {
                this.button3 = new JoystickButton(this.config.getButton3(), 2, this);
                this.thread.addFrameListener(this.button3);
            }
            if (this.config.getButton4() != null) {
                this.button4 = new JoystickButton(this.config.getButton4(), 3, this);
                this.thread.addFrameListener(this.button4);
            }
            if (this.config.getButton5() != null) {
                this.button5 = new JoystickButton(this.config.getButton5(), 4, this);
                this.thread.addFrameListener(this.button5);
            }
            if (this.config.getButtonF2() != null) {
                this.button_f2 = new JoystickButton(this.config.getButtonF2(), 5, this);
                this.thread.addFrameListener(this.button_f2);
            }
            if (this.config.getButtonF3() != null) {
                this.button_f3 = new JoystickButton(this.config.getButtonF3(), 6, this);
                this.thread.addFrameListener(this.button_f3);
            }
            if (this.config.getButtonF4() != null) {
                this.button_f4 = new JoystickButton(this.config.getButtonF4(), 7, this);
                this.thread.addFrameListener(this.button_f4);
            }
            if (this.config.getHatSwitch() != null) {
                this.hatSwitch = new JoystickHatSwitch(this.config.getHatSwitch(), this);
                this.thread.addFrameListener(this.hatSwitch);
            }
            this.xAxis = this.config.getAxisX();
            this.yAxis = this.config.getAxisY();
            this.sliderAxis = this.config.getAxisSlider();
            this.rotationAxis = this.config.getAxisRotation();
        }
        this.thread.addFrameListener(this);
        this.thread.start();
    }

    public static Joystick getInstance() {
        if (instance == null) {
            instance = new Joystick();
        }
        return instance;
    }

    public boolean isAvailable() {
        return this.available.get();
    }

    public boolean isFootpedalAvailable() {
        if (!this.isAvailable()) {
            return false;
        }
        return this.config.isFootpedalAvailable();
    }

    @Override
    public void handleFrame() {
        this.fireFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrameListener(FrameListener listener) {
        CopyOnWriteArrayList<FrameListener> copyOnWriteArrayList = this.frameListeners;
        synchronized (copyOnWriteArrayList) {
            this.frameListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrameListener(FrameListener listener) {
        CopyOnWriteArrayList<FrameListener> copyOnWriteArrayList = this.frameListeners;
        synchronized (copyOnWriteArrayList) {
            this.frameListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFrame() {
        CopyOnWriteArrayList<FrameListener> copyOnWriteArrayList = this.frameListeners;
        synchronized (copyOnWriteArrayList) {
            for (FrameListener listener : this.frameListeners) {
                listener.handleFrame();
            }
        }
    }

    @Override
    public void handleButtonPressed(int number) {
        this.fireButtonPressed(number);
    }

    public void addButtonListener(ButtonListener listener) {
        this.buttonListeners.add(listener);
    }

    public void removeButtonListener(ButtonListener listener) {
        this.buttonListeners.remove(listener);
    }

    protected void fireButtonPressed(int number) {
        for (ButtonListener listener : this.buttonListeners) {
            ButtonFirer firer = new ButtonFirer(listener, number);
            SwingUtilities.invokeLater(firer);
        }
    }

    @Override
    public void handleHatSwitch(int angle) {
        this.fireHatSwitch(angle);
    }

    public void addHatSwitchListener(HatSwitchListener listener) {
        this.headSwitchListeners.add(listener);
    }

    public void removeHatSwitchListener(HatSwitchListener listener) {
        this.headSwitchListeners.remove(listener);
    }

    protected void fireHatSwitch(int angle) {
        for (HatSwitchListener listener : this.headSwitchListeners) {
            HatSwitchFirer firer = new HatSwitchFirer(listener, angle);
            SwingUtilities.invokeLater(firer);
        }
    }

    public double getX() {
        if (this.xAxis != null) {
            return this.xAxis.getValue();
        }
        return 0.0;
    }

    public double getY() {
        if (this.yAxis != null) {
            return this.yAxis.getValue();
        }
        return 0.0;
    }

    public double getSlider() {
        if (this.sliderAxis != null) {
            return this.sliderAxis.getValue();
        }
        return 0.0;
    }

    public double getRotation() {
        if (this.rotationAxis != null) {
            return this.rotationAxis.getValue();
        }
        return 0.0;
    }

    public void setEnabled(boolean bool) {
        this.enabled.set(bool);
        this.thread.interrupt();
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }
}

