/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.informationordering.view;

import hsr.pma.app.joystick.ButtonListener;
import hsr.pma.app.view.components.ALabel;
import hsr.pma.app.view.components.NextButton;
import hsr.pma.app.view.graphics.ApplicationLayouter;
import hsr.pma.testapp.informationordering.pd.InformationOrdering;
import hsr.pma.testapp.informationordering.pd.ResultSlide;
import hsr.pma.testapp.informationordering.view.InformationOrderingLayouter;
import hsr.pma.testapp.informationordering.view.ProgressBarAnimator;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ResultSlidePanel
extends JPanel
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private JProgressBar progressBar;
    private JButton nextButton;
    private ResultSlide slide;
    private final InformationOrdering model;
    private InformationOrderingLayouter layouter;
    private JLabel title = new ALabel();

    public ResultSlidePanel(InformationOrdering model) {
        this.model = model;
        this.layouter = new InformationOrderingLayouter(this);
        this.setBackground(ApplicationLayouter.COLOR_BACKGROUND);
        this.setOpaque(true);
        this.setLayout(null);
        this.add(this.title);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(30);
        this.progressBar.setStringPainted(true);
        this.progressBar.setForeground(ApplicationLayouter.COLOR_TITLE);
        this.progressBar.setBackground(ApplicationLayouter.COLOR_BACKGROUND);
        this.progressBar.setBorder(BorderFactory.createLineBorder(ApplicationLayouter.COLOR_TITLE));
        this.add(this.progressBar);
        this.nextButton = new NextButton();
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ResultSlidePanel.this.handleNextPressed();
            }
        });
        this.add(this.nextButton);
    }

    public void setSlide(ResultSlide slide) {
        this.slide = slide;
        if (slide.hasNextButton()) {
            this.nextButton.setVisible(true);
        } else {
            this.nextButton.setVisible(false);
        }
        this.title.setText(slide.getTitle());
        int x = (int)Math.round(this.model.getResult() * 100.0);
        ProgressBarAnimator pba = new ProgressBarAnimator(this.progressBar, x);
        pba.start();
        this.myLayout();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width < 10) {
            return;
        }
        if (height < 10) {
            return;
        }
        this.myLayout();
    }

    private void myLayout() {
        this.layouter.layoutTitle(this.title);
        this.layouter.layoutNextButton(this.nextButton);
        this.layouter.layoutProgressBar(this.progressBar);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    private void handleNextPressed() {
        this.slide.handleNextPressed();
    }

    public void handleButtonPressed(int joystickButton) {
        switch (joystickButton) {
            case 4: {
                if (!this.slide.hasNextButton() || !this.nextButton.isEnabled()) break;
                this.dispatchActionEvent(this.nextButton);
            }
        }
    }

    private void dispatchActionEvent(JButton but) {
        but.getModel().setArmed(true);
        but.getModel().setPressed(true);
        Dimension d = but.getSize();
        but.paintImmediately(0, 0, d.width, d.height);
        ActionEvent evt = new ActionEvent(but, 1001, but.getActionCommand());
        ActionListener[] actionListenerArray = but.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener listener = actionListenerArray[n2];
            listener.actionPerformed(evt);
            ++n2;
        }
        but.getModel().setArmed(false);
        but.getModel().setPressed(false);
    }
}

