/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.informationordering.pd;

import hsr.pma.app.ResultStep;
import hsr.pma.testapp.informationordering.pd.Answer;
import hsr.pma.testapp.informationordering.pd.Symbol;
import hsr.pma.testapp.informationordering.pd.Type;
import hsr.pma.util.Time;
import java.util.ArrayList;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InformationOrderingResultStep
extends ResultStep {
    private static final long serialVersionUID = 1L;
    public static final String CLASS_NAME = "hsr.pma.testapp.informationordering.pd.InformationOrderingResultStep";
    private static final String XML_KEYWORD_ID = "idSlide";
    private static final String XML_KEYWORD_ISCORRECT = "isCorrect";
    private static final String XML_KEYWORD_STARTTIME = "StartTime";
    private static final String XML_KEYWORD_MILLIS = "millis";
    private static final String XML_KEYWORD_SYMBOL = "Symbol";
    private static final String XML_KEYWORD_SEQUENCE = "Sequence";
    private static final String XML_KEYWORD_SOLVEDQUASICORRECT = "SolvedQuasiCorrect";
    private static final String XML_KEYWORD_REPLYTIME = "ReactionTime";
    private static final String XML_KEYWORD_USERANSWER1 = "GivenAnswer1";
    private static final String XML_KEYWORD_USERANSWER2 = "GivenAnswer2";
    private static final String XML_KEYWORD_CORRECT_ANSWER1 = "CorrectAnswer1";
    private static final String XML_KEYWORD_CORRECT_ANSWER2 = "CorrectAnswer2";
    private boolean solvedCorrect;
    private int idSlide;
    private long reactionTime;
    private String sequence;
    private Symbol symbol;
    private boolean solvedQuasiCorrect;
    private String answer1Correct;
    private String answer2Correct;
    private String userAnswer1;
    private String userAnswer2;
    private Type type;

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public void setIdSlide(int id) {
        this.idSlide = id;
    }

    public void setReactionTime(long replyTime) {
        this.reactionTime = replyTime;
    }

    public void setUserAnswer1(String userAnswer1) {
        this.userAnswer1 = userAnswer1;
    }

    public void setUserAnswer2(String userAnswer2) {
        this.userAnswer2 = userAnswer2;
    }

    public void setSolvedCorrect(boolean solvedCorrect) {
        this.solvedCorrect = solvedCorrect;
    }

    public void setAnswer1Correct(String answer1Correct) {
        this.answer1Correct = answer1Correct;
    }

    public void setAnswer2Correct(String answer2Correct) {
        this.answer2Correct = answer2Correct;
    }

    public int getIdSlide() {
        return this.idSlide;
    }

    public boolean isSolvedCorrect() {
        return this.solvedCorrect;
    }

    public boolean isSolvedQuasiCorrect() {
        return this.solvedQuasiCorrect;
    }

    public void setSolvedQuasiCorrect(boolean solvedQuasiCorrect) {
        this.solvedQuasiCorrect = solvedQuasiCorrect;
    }

    public void setSmybol(Symbol smybol) {
        this.symbol = smybol;
    }

    public void setSequence(ArrayList<Answer> answers) {
        StringBuilder sb = new StringBuilder();
        for (Answer answer : answers) {
            sb.append(answer.number);
            sb.append(" ");
        }
        sb.deleteCharAt(sb.length() - 1);
        this.sequence = sb.toString();
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getAnswer1Correct() {
        return this.answer1Correct;
    }

    public String getAnswer2Correct() {
        return this.answer2Correct;
    }

    public long getReactionTime() {
        return this.reactionTime;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public Type getType() {
        return this.type;
    }

    public String getUserAnswer1() {
        return this.userAnswer1;
    }

    public String getUserAnswer2() {
        return this.userAnswer2;
    }

    @Override
    public Element toXML() {
        Element elem = new Element("ResultStep");
        elem.setAttribute(XML_KEYWORD_ID, new Integer(this.idSlide).toString());
        elem.setAttribute("time", this.started.toString());
        elem.setAttribute(XML_KEYWORD_ISCORRECT, "" + this.solvedCorrect);
        Element reactionTimeElem = new Element(XML_KEYWORD_REPLYTIME);
        reactionTimeElem.setText(new Long(this.reactionTime).toString());
        elem.addContent(reactionTimeElem);
        Element eseq = new Element(XML_KEYWORD_SEQUENCE);
        eseq.setText(this.sequence);
        elem.addContent(eseq);
        Element esym = new Element(XML_KEYWORD_SYMBOL);
        esym.setText(this.symbol.toString());
        elem.addContent(esym);
        if (this.type != null) {
            Element etype = new Element("Type");
            etype.setText(this.type.toString());
            elem.addContent(etype);
        }
        Element el = new Element(XML_KEYWORD_SOLVEDQUASICORRECT);
        el.setText("" + this.solvedQuasiCorrect);
        elem.addContent(el);
        Element correctionElem1 = new Element(XML_KEYWORD_CORRECT_ANSWER1);
        correctionElem1.setText(this.answer1Correct);
        elem.addContent(correctionElem1);
        Element correctionElem2 = new Element(XML_KEYWORD_CORRECT_ANSWER2);
        correctionElem2.setText(this.answer2Correct);
        elem.addContent(correctionElem2);
        Element userAnswersElem1 = new Element(XML_KEYWORD_USERANSWER1);
        userAnswersElem1.setText(this.userAnswer1);
        elem.addContent(userAnswersElem1);
        Element userAnswersElem2 = new Element(XML_KEYWORD_USERANSWER2);
        userAnswersElem2.setText(this.userAnswer2);
        elem.addContent(userAnswersElem2);
        return elem;
    }

    public static InformationOrderingResultStep fromXML(Element elem) {
        String time;
        InformationOrderingResultStep resultStep = new InformationOrderingResultStep();
        String x = elem.getAttributeValue(XML_KEYWORD_ISCORRECT);
        resultStep.solvedCorrect = Boolean.parseBoolean(x);
        resultStep.idSlide = Integer.parseInt(elem.getAttributeValue(XML_KEYWORD_ID));
        Element el = elem.getChild(XML_KEYWORD_STARTTIME);
        if (el != null) {
            x = el.getText();
            String y = el.getAttributeValue(XML_KEYWORD_MILLIS);
            resultStep.started = new Time(String.valueOf(x) + "." + y);
        }
        if ((time = elem.getAttributeValue("time")) != null && time.length() > 0) {
            resultStep.started = new Time(time);
        }
        resultStep.sequence = elem.getChildText(XML_KEYWORD_SEQUENCE);
        resultStep.symbol = Symbol.valueOf(elem.getChildText(XML_KEYWORD_SYMBOL));
        resultStep.reactionTime = Long.parseLong(elem.getChildText(XML_KEYWORD_REPLYTIME));
        resultStep.solvedQuasiCorrect = Boolean.parseBoolean(elem.getChildText(XML_KEYWORD_SOLVEDQUASICORRECT));
        if (elem.getChild("Type") != null) {
            resultStep.type = Type.valueOf(elem.getChild("Type").getText());
        }
        resultStep.answer1Correct = elem.getChildText(XML_KEYWORD_CORRECT_ANSWER1);
        resultStep.answer2Correct = elem.getChildText(XML_KEYWORD_CORRECT_ANSWER2);
        resultStep.userAnswer1 = elem.getChildText(XML_KEYWORD_USERANSWER1);
        resultStep.userAnswer2 = elem.getChildText(XML_KEYWORD_USERANSWER2);
        return resultStep;
    }
}

