/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.informationordering.pd;

import hsr.pma.Language;
import hsr.pma.app.DefaultTestApplication;
import hsr.pma.app.IResultStep;
import hsr.pma.app.ITestApplication;
import hsr.pma.app.ResultStep;
import hsr.pma.app.view.ObserverArg;
import hsr.pma.app.view.feedback.FeedbackFactory;
import hsr.pma.testapp.informationordering.pd.ActionSlide;
import hsr.pma.testapp.informationordering.pd.ExampleSlide;
import hsr.pma.testapp.informationordering.pd.InfoSlide;
import hsr.pma.testapp.informationordering.pd.InformationOrderingResultStep;
import hsr.pma.testapp.informationordering.pd.ResultSlide;
import hsr.pma.testapp.informationordering.pd.Slide;
import hsr.pma.testapp.informationordering.view.InformationOrderingPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javax.swing.JPanel;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InformationOrdering
extends DefaultTestApplication {
    private static final long serialVersionUID = 1L;
    public static final String APPLICATION_NAME = "Information-Ordering";
    public static final String CLASS_NAME = "hsr.pma.testapp.informationordering.pd.InformationOrdering";
    public static final String CLASS_NAME_RESULTSTEP = "hsr.pma.testapp.informationordering.pd.InformationOrderingResultStep";
    public static final int OBS_SHOW_SLIDE = 600;
    public static final int OBS_JOYSTICK_BUTTON_PRESSED = 601;
    private double delayTest = 0.0;
    private double delayFeedback = 0.0;
    private ArrayList<Slide> instructionSlides = new ArrayList();
    private ArrayList<Slide> testSlides = new ArrayList();
    private ArrayList<ArrayList<Slide>> multiTestSlides = new ArrayList();
    private int indexNextInstructionSlide = 0;
    private int indexNextTestSlide = 0;
    private ArrayList<IResultStep> resultStepsTest = new ArrayList();
    private ArrayList<IResultStep> resultStepsInstruction = new ArrayList();
    private ArrayList<String> buttonLabels = new ArrayList();
    private boolean randomizedPool = false;
    private int randomizedPoolExerciseCount = 10;
    private int multiTestIndex = 0;
    Random random = new Random(System.currentTimeMillis());
    private boolean displayNextButton = true;
    private boolean debug = false;

    @Override
    public String getApplicationName() {
        return APPLICATION_NAME;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassNameResultStep() {
        return CLASS_NAME_RESULTSTEP;
    }

    @Override
    public Element getConfiguration() {
        Element dt;
        Element el = new Element("Configuration");
        Element init = new Element("Init");
        if (this.delayTest > 0.0) {
            dt = new Element("DelayTest");
            dt.setText("" + this.delayTest);
            init.addContent(dt);
        }
        if (this.delayFeedback > 0.0) {
            dt = new Element("DelayFeedback");
            dt.setText("" + this.delayFeedback);
            init.addContent(dt);
        }
        if (this.randomizedPool) {
            Element erp = new Element("RandomizedPool");
            erp.setAttribute("exerciseCount", "" + this.randomizedPoolExerciseCount);
            erp.setText("true");
            init.addContent(erp);
        }
        if (!this.displayNextButton) {
            Element dnb = new Element("DisplayNextButton");
            el.setText("" + this.displayNextButton);
            init.addContent(dnb);
        }
        Element but1 = new Element("ButtonLabel1");
        but1.setText(this.buttonLabels.get(0));
        init.addContent(but1);
        Element but2 = new Element("ButtonLabel2");
        but2.setText(this.buttonLabels.get(1));
        init.addContent(but2);
        Element but3 = new Element("ButtonLabel3");
        but3.setText(this.buttonLabels.get(2));
        init.addContent(but3);
        Element but4 = new Element("ButtonLabel4");
        but4.setText(this.buttonLabels.get(3));
        init.addContent(but4);
        el.addContent(init);
        Element instruction = new Element("Instruction");
        for (Slide slide : this.instructionSlides) {
            instruction.addContent(slide.toXML());
        }
        el.addContent(instruction);
        int i = 0;
        while (i < this.multiTestSlides.size()) {
            Element test = new Element("Test");
            for (Slide slide : this.multiTestSlides.get(i)) {
                test.addContent(slide.toXML());
            }
            el.addContent(test);
            ++i;
        }
        return el;
    }

    @Override
    public void setConfiguration(Element arg0) {
        Element init = arg0.getChild("Init");
        this.setLanguage(Language.GERMAN);
        this.buttonLabels = new ArrayList();
        this.buttonLabels.add(init.getChildText("ButtonLabel1"));
        this.buttonLabels.add(init.getChildText("ButtonLabel2"));
        this.buttonLabels.add(init.getChildText("ButtonLabel3"));
        this.buttonLabels.add(init.getChildText("ButtonLabel4"));
        if (init.getChild("DelayTest") != null) {
            this.delayTest = Double.parseDouble(init.getChildText("DelayTest"));
        }
        if (init.getChild("DelayFeedback") != null) {
            this.delayFeedback = Double.parseDouble(init.getChildText("DelayFeedback"));
        }
        if (init.getChild("RandomizedPool") != null) {
            Element erp = init.getChild("RandomizedPool");
            this.randomizedPool = Boolean.parseBoolean(erp.getText());
            this.randomizedPoolExerciseCount = Integer.parseInt(erp.getAttributeValue("exerciseCount"));
        }
        if (init.getChild("DisplayNextButton") != null) {
            this.displayNextButton = Boolean.parseBoolean(init.getChildText("DisplayNextButton"));
        }
        Element instruction = arg0.getChild("Instruction");
        for (Object obj : instruction.getChildren()) {
            this.instructionSlides.add(this.parseSlide((Element)obj));
        }
        for (Object etest : arg0.getChildren("Test")) {
            Element test = (Element)etest;
            ArrayList<Slide> slides = new ArrayList<Slide>();
            for (Object obj : test.getChildren()) {
                slides.add(this.parseSlide((Element)obj));
            }
            this.multiTestSlides.add(slides);
        }
        this.testSlides = this.multiTestSlides.get(0);
    }

    private Slide parseSlide(Element el) {
        String name = el.getName();
        if (name.equals("InfoSlide")) {
            return InfoSlide.fromXML(el);
        }
        if (name.equals(ExampleSlide.XML_NAME)) {
            return ExampleSlide.fromXML(el);
        }
        if (name.equals(ActionSlide.XML_NAME)) {
            ActionSlide as = ActionSlide.fromXML(el);
            as.setNextButton(this.displayNextButton);
            return as;
        }
        if (name.equals("ResultSlide")) {
            return ResultSlide.fromXML(el);
        }
        throw new RuntimeException("Unknown Slide " + el.getName());
    }

    @Override
    public void setPanel(JPanel panel) {
        if (this.debug) {
            System.out.println("[InformationOrdering:setPanel()]");
        }
        panel.setLayout(new BorderLayout());
        InformationOrderingPanel iop = new InformationOrderingPanel(this);
        panel.add((Component)iop, "Center");
        panel.validate();
        panel.repaint();
    }

    @Override
    public void startInstruction() {
        if (this.debug) {
            System.out.println("[InformationOrdering:startInstruction()]");
        }
        this.resultStepsInstruction.clear();
        this.setState(ITestApplication.State.INSTRUCTING);
        this.indexNextInstructionSlide = 0;
        this.showNextSlide();
    }

    public void showNextSlide() {
        switch (this.getState()) {
            case INSTRUCTING: {
                this.showNextSlideInstruction();
                break;
            }
            case TESTING: {
                this.showNextSlideTest();
            }
        }
    }

    private void showNextSlideInstruction() {
        try {
            Slide slide = this.instructionSlides.get(this.indexNextInstructionSlide);
            slide.start();
            this.setChanged();
            this.notifyObservers(new ObserverArg(600, slide));
            ++this.indexNextInstructionSlide;
        }
        catch (IndexOutOfBoundsException e) {
            this.setState(ITestApplication.State.PAUSE);
        }
    }

    private void showNextSlideTest() {
        try {
            Slide slide = this.testSlides.get(this.indexNextTestSlide);
            slide.start();
            this.setChanged();
            this.notifyObservers(new ObserverArg(600, slide));
            ++this.indexNextTestSlide;
        }
        catch (IndexOutOfBoundsException e) {
            this.setState(ITestApplication.State.ENDED);
        }
    }

    @Override
    public void startTest() {
        if (this.debug) {
            System.out.println("[InformationOrdering:startTest()]");
        }
        this.resultStepsTest.clear();
        this.prepareTestSlides();
        this.setState(ITestApplication.State.TESTING);
        this.indexNextTestSlide = 0;
        this.showNextSlide();
    }

    private void prepareTestSlides() {
        ArrayList<Slide> slides = this.multiTestSlides.get(this.multiTestIndex);
        if (!this.randomizedPool) {
            this.testSlides = slides;
            return;
        }
        ArrayList<ActionSlide> aslides = new ArrayList<ActionSlide>();
        for (Slide slide : slides) {
            if (!(slide instanceof ActionSlide)) continue;
            aslides.add((ActionSlide)slide);
        }
        Collections.shuffle(aslides, this.random);
        ArrayList<Slide> shuffled = new ArrayList<Slide>();
        int count = 0;
        for (Slide slide : slides) {
            if (!(slide instanceof ActionSlide)) {
                shuffled.add(slide);
                continue;
            }
            if (count >= this.randomizedPoolExerciseCount) continue;
            shuffled.add((Slide)aslides.remove(aslides.size() - 1));
            ++count;
        }
        this.testSlides = shuffled;
    }

    @Override
    public void startTest(int index) {
        if (index >= this.getTestCount()) {
            System.err.println("not enough tests, start first one");
            index = 0;
        }
        this.multiTestIndex = index;
        this.startTest();
    }

    @Override
    public int getTestCount() {
        return this.multiTestSlides.size();
    }

    @Override
    public void stopInstruction() {
        if (this.debug) {
            System.out.println("[InformationOrdering:stopInstruction()]");
        }
        this.setState(ITestApplication.State.PAUSE);
        if (this.indexNextInstructionSlide > 0) {
            Slide activeSlide = this.instructionSlides.get(this.indexNextInstructionSlide - 1);
            activeSlide.stop();
        }
    }

    @Override
    public void stopTest() {
        if (this.debug) {
            System.out.println("[InformationOrdering:stopTest()]");
        }
        this.setState(ITestApplication.State.ENDED);
        if (this.indexNextTestSlide > 0) {
            Slide activeSlide = this.testSlides.get(this.indexNextTestSlide - 1);
            activeSlide.stop();
        }
    }

    @Override
    public Element toXML() {
        Element element = new Element("TestApplication");
        this.writeAttributesToXML(element);
        element.addContent(this.getConfiguration());
        return element;
    }

    public static InformationOrdering fromXML(Element element) {
        try {
            InformationOrdering app = new InformationOrdering();
            app.setAttributesFromXML(element);
            app.setConfiguration(element.getChild("Configuration"));
            app.setLanguage(app.getLanguage());
            return app;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setLanguage(Language language) {
        if (this.debug) {
            System.out.println("[InformationOrdering:setLanguage()]");
        }
        super.setLanguage(language);
        for (Slide slide : this.instructionSlides) {
            slide.setLanguage(language);
        }
        int i = 0;
        while (i < this.multiTestSlides.size()) {
            for (Slide slide : this.multiTestSlides.get(i)) {
                slide.setLanguage(language);
            }
            ++i;
        }
    }

    public void saveResultStep(ResultStep step) {
        if (this.debug) {
            System.out.println("[InformationOrdering:saveResultStep()]");
        }
        switch (this.state) {
            case INSTRUCTING: {
                this.resultStepsInstruction.add(step);
                break;
            }
            case TESTING: {
                this.resultStepsTest.add(step);
                this.setChanged();
                this.notifyObservers(new ObserverArg(2, step));
            }
        }
    }

    public double getResult() {
        switch (this.state) {
            case READY: 
            case INSTRUCTING: 
            case PAUSE: {
                return this.getResultInstruction();
            }
            case TESTING: 
            case ENDED: {
                return this.getResultTest();
            }
        }
        return 0.0;
    }

    private double getResultInstruction() {
        return this.calcResult(this.resultStepsInstruction);
    }

    private double getResultTest() {
        return this.calcResult(this.resultStepsTest);
    }

    private double calcResult(ArrayList<IResultStep> steps) {
        int counter = 0;
        int oks = 0;
        for (IResultStep step : steps) {
            InformationOrderingResultStep iostep = (InformationOrderingResultStep)step;
            if (iostep.isSolvedCorrect()) {
                ++oks;
            }
            ++counter;
        }
        if (counter == 0) {
            return 0.0;
        }
        return (double)oks / (double)counter;
    }

    @Override
    public void setResultSteps(ArrayList<IResultStep> list) {
        this.resultStepsTest = list;
    }

    @Override
    public void startFailover() {
        if (this.debug) {
            System.out.println("[InformationOrdering:startFailOver()]");
        }
        if (this.resultStepsTest.size() == 0) {
            this.indexNextTestSlide = 0;
        } else {
            IResultStep lastStep = this.resultStepsTest.get(this.resultStepsTest.size() - 1);
            int idSlide = ((InformationOrderingResultStep)lastStep).getIdSlide();
            int index = this.findIndexSlide(idSlide);
            this.indexNextTestSlide = index = (index + 1) % this.testSlides.size();
            if (this.indexNextTestSlide == -1) {
                RuntimeException re = new RuntimeException("[InformationOrdering] Fail-Over: Wiederherstellungspunkt konnte nicht ermittelt werden.");
                this.setChanged();
                this.notifyObservers(new ObserverArg(3, re));
                return;
            }
        }
        this.setState(ITestApplication.State.TESTING);
        this.showNextSlideTest();
    }

    private int findIndexSlide(int id) {
        int i = 0;
        while (i < this.testSlides.size()) {
            ActionSlide aslide;
            Slide slide = this.testSlides.get(i);
            if (slide instanceof ActionSlide && (aslide = (ActionSlide)slide).getId() == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void handleButtonPressed(int joystickButton) {
        this.setChanged();
        this.notifyObservers(new ObserverArg(601, joystickButton));
    }

    public ArrayList<String> getButtonLabels() {
        return this.buttonLabels;
    }

    public double getDelayTest() {
        return this.delayTest;
    }

    public double getDelayFeedback() {
        return this.delayFeedback;
    }

    @Override
    public void abort() {
        if (this.debug) {
            System.out.println("[InformationOrdering:abort()]");
        }
        if (this.state == ITestApplication.State.INSTRUCTING) {
            if (this.indexNextInstructionSlide > 0) {
                Slide activeSlide = this.instructionSlides.get(this.indexNextInstructionSlide - 1);
                activeSlide.stop();
            }
        } else if (this.state == ITestApplication.State.TESTING && this.indexNextTestSlide > 0) {
            Slide activeSlide = this.testSlides.get(this.indexNextTestSlide - 1);
            activeSlide.stop();
        }
    }

    @Override
    public void init() {
        if (this.debug) {
            System.out.println("[InformationOrdering:init()]");
        }
        for (Slide slide : this.instructionSlides) {
            slide.setModel(this);
        }
        int i = 0;
        while (i < this.multiTestSlides.size()) {
            for (Slide slide : this.multiTestSlides.get(i)) {
                slide.setModel(this);
            }
            ++i;
        }
    }

    @Override
    public void setStandalone(boolean bool) {
        if (this.debug) {
            System.out.println("[InformationOrdering:setStandalone()]");
        }
        super.setStandalone(bool);
    }

    @Override
    public void dispose() {
        FeedbackFactory.provide(null);
    }
}

