/*
 * Decompiled with CFR 0.152.
 */
package hsr.pma.testapp.informationordering.pd;

import hsr.pma.Language;
import hsr.pma.testapp.informationordering.pd.NextListener;
import hsr.pma.testapp.informationordering.pd.Slide;
import hsr.pma.testapp.informationordering.pd.TimeoutWatchdog;
import java.util.HashMap;
import org.jdom.Element;

public class InfoSlide
extends Slide
implements NextListener {
    private static final long serialVersionUID = 1L;
    public static final String XML_NAME = "InfoSlide";
    protected boolean hasNextButton = true;
    protected int timeout = 0;
    protected TimeoutWatchdog dog;
    protected HashMap<Language, String> titles = new HashMap();
    protected HashMap<Language, String> texts = new HashMap();

    public boolean hasNextButton() {
        return this.hasNextButton;
    }

    public void setNextButton(boolean visible) {
        this.hasNextButton = visible;
    }

    public boolean hasTimeout() {
        return this.timeout > 0;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getText() {
        String x = this.texts.get((Object)this.language);
        if (x == null) {
            x = "";
        }
        return x;
    }

    public String getTitle() {
        String x = this.titles.get((Object)this.language);
        if (x == null) {
            x = "";
        }
        return x;
    }

    public static InfoSlide fromXML(Element el) {
        InfoSlide slide = new InfoSlide();
        InfoSlide.fromXML(el, slide);
        return slide;
    }

    public static void fromXML(Element el, InfoSlide slide) {
        Element etext;
        Element title;
        String timeout;
        String hasNextButton = el.getAttributeValue("nextButton");
        if (hasNextButton != null) {
            boolean value;
            slide.hasNextButton = value = Boolean.parseBoolean(hasNextButton);
        }
        if ((timeout = el.getAttributeValue("timeout")) != null) {
            int iValue;
            double value = Double.parseDouble(timeout);
            slide.timeout = iValue = (int)(value * 1000.0);
        }
        if ((title = el.getChild("Title")) != null) {
            for (Object obj : title.getChildren()) {
                Element e = (Element)obj;
                String name = e.getName();
                Language lang = Language.valueOfAbbreviation(name);
                slide.titles.put(lang, e.getText());
            }
        }
        if ((etext = el.getChild("Text")) != null) {
            for (Object obj : etext.getChildren()) {
                Element e = (Element)obj;
                String name = e.getName();
                Language lang = Language.valueOfAbbreviation(name);
                slide.texts.put(lang, e.getText());
            }
        }
    }

    public Element toXML() {
        Element el = new Element(XML_NAME);
        if (this.hasTitle()) {
            Element title = new Element("Title");
            this.appendTitle(title, Language.GERMAN);
            this.appendTitle(title, Language.FRENCH);
            this.appendTitle(title, Language.ITALIAN);
            this.appendTitle(title, Language.ENGLISH);
            el.addContent(title);
        }
        if (this.hasText()) {
            Element text = new Element("Text");
            this.appendText(text, Language.GERMAN);
            this.appendText(text, Language.FRENCH);
            this.appendText(text, Language.ITALIAN);
            this.appendText(text, Language.ENGLISH);
            el.addContent(text);
        }
        if (!this.hasNextButton) {
            el.setAttribute("nextButton", "false");
        }
        if (this.hasTimeout()) {
            double time = (double)this.timeout / 1000.0;
            el.setAttribute("timeout", "" + time);
        }
        return el;
    }

    private boolean hasText() {
        return this.texts.size() > 0;
    }

    private boolean hasTitle() {
        return this.titles.size() > 0;
    }

    private void appendText(Element el, Language lang) {
        String x = this.texts.get((Object)lang);
        if (x == null) {
            return;
        }
        Element child = new Element(lang.abbreviation);
        child.setText(x);
        el.addContent(child);
    }

    private void appendTitle(Element el, Language lang) {
        String x = this.titles.get((Object)lang);
        if (x == null) {
            return;
        }
        Element child = new Element(lang.abbreviation);
        child.setText(x);
        el.addContent(child);
    }

    public void start() {
        if (this.timeout != 0) {
            this.dog = new TimeoutWatchdog(this, this.timeout);
            this.dog.start();
        }
    }

    public void stop() {
        if (this.dog != null && this.dog.isAlive()) {
            this.dog.shutdown();
        }
    }

    public void handleNextPressed() {
        this.stop();
        this.model.showNextSlide();
    }
}

